#include <bits/stdc++.h>
#define ll long long
using namespace std;

const int MAXN = 1e5 + 5;
int N;
ll sol;
bool A[MAXN];
struct Point
{
    int idx;
    ll x, y;
}P[MAXN], p0, P1[MAXN];
vector<int> Hull, Hull1, HullN;

bool Orientation(Point a, Point b, Point c)
{
    ll v = a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y);
    return v > 0;
}

bool cmp(Point a, Point b)
{
    return Orientation(p0, a, b);
}

bool rev(Point a, Point b)
{
    return a.idx < b.idx;
}

ll Area(vector<int> V)
{
    if(V.size() < 3) return 0;
    ll ret = 0;
    int j  = V.size() - 1;
    for(int i = 0; i < V.size(); i++) ret += (P[V[i]].x + P[V[j]].x) * (P[V[i]].y - P[V[j]].y), j = i;
    return abs(ret) / 2;
}

ll TArea(Point a, Point b, Point c)
{
    return abs(a.x * (b.y - c.y) + b.x * (c.y - a.y) + c.x * (a.y - b.y)) / 2;
}

vector<int> Convex_Hull(int l, int r)
{
    vector<int> ret;
    for(int i = l; i <= r; i++)
    {
        if(!A[i]) continue;
        while(ret.size() > 1 and !Orientation(P[ret[ret.size() - 2]], P[ret.back()], P[i])) ret.pop_back();
        ret.push_back(i);
    }
    return ret;
}

ll FindMax()
{
    ll ret = 0;
    ll temp;
    for(int i = 1; i < Hull.size() - 1; i++)
    {
        A[Hull[i]] = 0;
        temp = TArea(P[Hull[i - 1]], P[Hull[i]], P[Hull[i + 1]]);
        temp -= Area(Convex_Hull(Hull[i - 1], Hull[i + 1]));
        ret = max(temp, ret);
        A[Hull[i]] = 1;
    }
    return ret;
}

ll HULLN(int p)
{
    vector<int> V;
    for(int i = 1; i < N; i++)
    {
        while(V.size() > 1 and !Orientation(P[V[V.size() - 2]], P[V.back()], P[i])) V.pop_back();
        V.push_back(i);
    }
    return Area(V);
}

ll HULL1(int p)
{
    int cnt = 0;
    for(int i = 1; i <= N; i++) if(i != p) P1[++cnt] = P[i];
    int idx = 1;
    for(int i = 1; i <= cnt; i++) if(P1[i].y < P1[idx].y) idx = i;
    p0 = P1[idx];
    swap(P1[idx], P1[1]);
    sort(P1 + 2, P1 + N + 1, cmp);
    vector<int> H;
    for(int i = 1; i <= cnt; i++)
    {
        while(H.size() > 1 and !Orientation(P1[H[H.size() - 2]], P1[H.back()], P1[i])) H.pop_back();
        H.push_back(i);
    }

    ll ret = 0;
    int j  = H.size() - 1;
    for(int i = 0; i < H.size(); i++) ret += (P1[H[i]].x + P1[H[j]].x) * (P1[H[i]].y - P1[H[j]].y), j = i;
    return abs(ret) / 2;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cin >> N;
    for(int i = 1; i <= N; i++) A[i] = 1;
    for(int i = 1; i <= N; i++) cin >> P[i].x >> P[i].y, P[i].idx = i;
    int idx = 1;
    for(int i = 2; i <= N; i++) if(P[i].y < P[idx].y) idx = i;
    p0 = P[idx];
    swap(P[idx], P[1]);
    sort(P + 2, P + N + 1, cmp);
    Hull = Convex_Hull(1, N);
//    for(int i = 1; i <= N; i++) cout << P[i].idx << "\n";
    sol = Area(Hull) - FindMax();
    sol = min(sol, HULLN(P[N].idx));
    sol = min(sol, HULL1(P[1].idx));
    cout << sol << "\n";
    return 0;
}